import React from 'react';

interface CheckBoxProps {
  fieldName: string;
  fieldLabel?: string;
  jsxFieldLabel?: JSX.Element;
  register: any; // You can replace 'any' with a more specific type if needed
  required?: boolean;
  defaultChecked?: boolean;
  onChangeFn?: (checked: boolean) => void;
}

const CheckBox: React.FC<CheckBoxProps> = ({
  fieldName,
  fieldLabel,
  jsxFieldLabel,
  register,
  required,
  defaultChecked,
  onChangeFn,
}) => {
  return (
    <div className="">
      <input
        id={fieldName}
        type="checkbox"
        defaultChecked={defaultChecked}
        {...register(fieldName, {
          required: required ? 'This field is required.' : false,
        })}
        onChange={({ target: { checked } }) =>
          onChangeFn && onChangeFn(checked)
        }
      />
      {fieldLabel ||
        (jsxFieldLabel && (
          <label htmlFor={fieldName}>
            {jsxFieldLabel ? jsxFieldLabel : fieldLabel}
          </label>
        ))}
    </div>
  );
};

export default CheckBox;