interface OptionType {
  value: string;
  label: string;
}

export interface FieldProps {
  register?: any;
  control?: any;
  fieldName: string;
  fieldLabel?: string;
  withLabel?: boolean;
  setValue?: any;
  registerOptions?: Record<string, unknown>;
  type: string;
  required?: boolean;
  isValidated?: boolean;
  validateFn?: () => void;
  onChangeFn?: () => void;
  handleKeyDown?: () => void;
  defaultValue?: any;
  placeholder?: string;
  isDisabled?: boolean;
  maxLength?: number;
  optionsData?: OptionType[] | string[];
  labelKey?: string;
  valueKey?: string;
  returnOnlyValue?: boolean;
  radioOptions?: any[];
  withDescription?: boolean;
  defaultChecked?: any;
  defaultStatus?: boolean;
  controlled?: boolean;
  controlledCheck?: boolean;
  tooltip?: string;
  jsxFieldLabel?: ReactElement;
  moreCss?: string;
  message?: string;
  allowedSize?: number;
  allowedTypes?: string[];
  dynamic?: {
    grandParent?: string;
    grandParentType?: string;
    parentIndex?: number;
    parent?: string;
    index?: string;
    fieldName: string;
    type?: string;
    fileName?: string;
  };
}

export interface FieldType {
  content: ReactElement | null;
  type: string;
}

export interface DynamicFieldErrorProps {
  dynamic: any;
  errors: any;
}

export interface FormElementProps {
  fieldName: string;
  fieldLabel?: string;
  withLabel?: boolean;
  required?: boolean;
  dynamic?: {
    grandParent?: string;
    grandParentType?: string;
    parentIndex?: number;
    parent?: string;
    index?: string;
    fieldName: string;
    type?: string;
  };
  // You can add more specific types for other props if needed
}
