import {
  Heart,
  Search,
  ShoppingBasket,
  User,
  X,
  Twitter,
  Facebook,
  Instagram,
  Github,
} from "lucide-react";
import { Link } from "@remix-run/react";
import { useState } from "react";
import { svgs } from "~/assets";

interface AuthLayoutProp {
  children: React.ReactNode;
}

const DefaultLayout = ({ children }: AuthLayoutProp) => {
  const [discount, setDiscount] = useState(true);
  const sections = [
    {
      title: "Company",
      links: ["About", "Features", "Works", "Career"],
    },
    {
      title: "Help",
      links: [
        "Customer Support",
        "Delivery Details",
        "Terms & Conditions",
        "Privacy Policy",
      ],
    },
    {
      title: "FAQ",
      links: ["Account", "Manage Deliveries", "Orders", "Payments"],
    },
    {
      title: "Resources",
      links: [
        "Free eBooks",
        "Development Tutorial",
        "How to - Blog",
        "Youtube Playlist",
      ],
    },
  ];

  return (
    <main className="relative">
      <div className="fixed z-50 w-full bg-white shadow-lg">
        {discount && (
          <div className="flex text-center gap-2 bg-black text-white py-2">
            <p className="w-full">
              Sign up and get 20% off to your first order.{" "}
              <Link className="font-semibold border-b-2" to={"/user/signup"}>
                Sign Up Now
              </Link>
            </p>
            <button
              onClick={() => setDiscount(false)}
              className="w-full max-w-32"
            >
              <X />
            </button>
          </div>
        )}
        <div className="max-w-8xl mx-auto px-10 py-5 flex items-center">
          <div className="w-full">
            <img src={svgs.logo} alt="Profile Images" className="h-10 w-fit" />
          </div>
          <div className="w-full flex items-center gap-14">
            <div className="flex gap-2 items-center w-full bg-slate-100 rounded-md">
              <span className="px-4 py-3">
                <Search color="#989898" />
              </span>
              <input
                placeholder="I’m looking for..."
                className="bg-transparent"
              />
            </div>
            <div className="flex gap-5">
              <button className="hover:bg-slate-100 p-2 rounded-md">
                <Heart size={30} />
              </button>
              <button className="hover:bg-slate-100 p-2 rounded-md">
                <User size={30} />
              </button>
              <button className="relative hover:bg-slate-100 p-2 rounded-md">
                <ShoppingBasket size={30} />
                <div className="absolute right-1 top-7 flex items-center justify-center text-white text-[10px] bg-primary rounded-full h-4 w-4">
                  0
                </div>
              </button>
            </div>
          </div>
        </div>
      </div>
      <div className="absolute left-0 top-32 w-full h-screen">
        {children}
        <footer className="bg-gray-100 py-10">
          <div className="container mx-auto px-6 lg:px-20 grid grid-cols-1 md:grid-cols-5 gap-6">
            {/* Brand Section */}
            <div className="md:col-span-1">
              <h3 className="text-3xl font-bold mb-4">OnePrint</h3>
              <p className="text-gray-600 leading-relaxed mb-10 max-w-40">
                High-quality, customizable products to bring your brand or event
                to life.
              </p>
              <div className="flex space-x-4">
                <a href="#" className="text-gray-600 hover:text-gray-800">
                  <Twitter />
                </a>
                <a href="#" className="text-gray-600 hover:text-gray-800">
                  <Facebook />
                </a>
                <a href="#" className="text-gray-600 hover:text-gray-800">
                  <Instagram />
                </a>
                <a href="#" className="text-gray-600 hover:text-gray-800">
                  <Github />
                </a>
              </div>
            </div>

            {/* Sections */}
            {sections.map((section, index) => (
              <div key={index} className="space-y-6 md:col-span-1">
                <h4 className="text-lg font-semibold mb-4 uppercase">
                  {section.title}
                </h4>
                <ul className="space-y-4 text-gray-600">
                  {section.links.map((link, linkIndex) => (
                    <li key={linkIndex}>
                      <Link to="#" className="hover:text-gray-800">
                        {link}
                      </Link>
                    </li>
                  ))}
                </ul>
              </div>
            ))}
          </div>

          <hr className="mb-6 mt-14 border-gray-300" />

          {/* Footer Bottom */}
          <div className="container mx-auto px-6 lg:px-20 flex flex-col md:flex-row justify-between items-center space-y-4 md:space-y-0">
            <p className="text-gray-600 pb-2">
              Imprint © 2000-2024, All Rights Reserved
            </p>
            <div className="flex">
              <img src={svgs.visa} alt="Visa" className="h-14" />
              <img src={svgs.mastercard} alt="Mastercard" className="h-14" />
              <img src={svgs.paypal} alt="PayPal" className="h-14" />
              <img src={svgs.applepay} alt="Apple Pay" className="h-14" />
              <img src={svgs.googlepay} alt="Google Pay" className="h-14" />
            </div>
          </div>
        </footer>
      </div>
    </main>
  );
};

export default DefaultLayout;
