import { Heart } from "lucide-react";
import { useState } from "react";
import { Button } from "~/components/ui/button";

interface BestProductsProps {
  image: string;
  name: string;
  price: number;
}

const BestProducts = ({ image, name, price }: BestProductsProps) => {
  const [hearted, setHearted] = useState<boolean>(false);
  return (
    <div className="relative flex flex-col gap-2 text-center group hover:cursor-pointer">
      <div className="absolute right-5 top-5 p-2 rounded-full bg-white w-fit">
        <Heart
          onClick={() => setHearted(!hearted)}
          size={20}
          color={hearted ? "none" : "black"}
          fill={hearted ? "red" : "none"}
        />
      </div>
      <img src={image} alt={name} className="mx-auto h-96 w-full rounded-2xl" />
      <Button
        text="Customize Now"
        className="invisible translate-y-5 group-hover:translate-y-0 group-hover:visible transform transition-transform duration-300 absolute bottom-20 left-7 px-28 py-6 text-lg mx-auto"
      />
      <div>
        <p className="text-left text-lg uppercase text-slate-400">{name}</p>
        <p className="text-left font-semibold">${price} (per piece)</p>
      </div>
    </div>
  );
};

export default BestProducts;
