import { ArrowRight } from "lucide-react";

interface CategoryProps {
  productCategory: Array<{
    image: string;
    name: string;
  }>;
}

const Category = ({ productCategory }: CategoryProps) => {
  return (
    <div className="grid grid-cols-4 gap-x-6 gap-y-8">
      {productCategory.map((category, index) => (
        <div
          key={index}
          className="flex flex-col gap-2 text-center group hover:cursor-pointer"
        >
          <img
            src={category.image}
            alt={category.name}
            className="mx-auto transform transition-transform duration-300 group-hover:scale-105"
          />
          <p className="flex items-center gap-2 w-fit mx-auto text-lg">
            {category.name}{" "}
            <span className="hidden group-hover:block transition-opacity">
              <ArrowRight />
            </span>
          </p>
        </div>
      ))}
    </div>
  );
};

export default Category;
