import { Button } from "~/components/ui/button";
import AuthLayout from "../layout/Auth";
import Heading from "~/components/core/Text/Heading";
import { useNavigate } from "@remix-run/react";

const AuthHeading = {
  title: "",
  subtitle: "",
};

const MainHeading = {
  title: "Account Verified Successfully",
  subtitle: "Your account has been verified successfully",
};

const OTP = () => {
  const navigate = useNavigate();

  return (
    <AuthLayout title={AuthHeading.title} subtitle={AuthHeading.subtitle}>
      <Heading title={MainHeading.title} subtitle={MainHeading.subtitle} />
      <Button
        size="lg"
        text="Go to login"
        className="w-full my-4"
        onClick={() => {
          navigate("/user/login");
        }}
      />
    </AuthLayout>
  );
};

export default OTP;
