export interface UserResponse {
  access: string;
  refresh: string;
  user: UserDataProps;
}

export interface SignUpResponse {
  status: number;
  success: boolean;
  data: {
    detail: string;
  };
  user: UserDataProps;
}

export interface UserDataProps {
  pk: number;
  username: string;
  email: string;
  first_name: string;
  last_name: string;
}

export interface LoginProps {
  password: string;
  email: string;
}

export interface SignupProps {
  username: string;
  email: string;
  first_name: string;
  last_name: string;
  phone_number: string;
  password: string;
  password2: string;
}

export interface ResetPasswordProps {
  new_password1: string;
  new_password2: string;
  uid: string | undefined;
  token: string | undefined;
}
