import React from "react";
import { Control, FieldValues } from "react-hook-form";
import PhoneInput from "react-phone-number-input/react-hook-form";
import "react-phone-number-input/style.css";

interface PhoneNumberProps {
  control: Control<FieldValues>;
  fieldName?: string;
  required?: boolean;
  maxLength: number | undefined;
  isDisabled?: boolean;
  defaultValue?: string;
  moreCss?: string;
}

const PhoneNumber: React.FC<PhoneNumberProps> = ({
  control,
  fieldName,
  required = false,
  maxLength,
  isDisabled = false,
  defaultValue,
  moreCss,
}) => {
  return (
    <div
      className={`w-full rounded border-2 border-stroke bg-transparent px-3 py-2.5 text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary ${moreCss}`}
    >
      <PhoneInput
        name={fieldName || "phoneNumber"}
        control={control}
        rules={{
          required: required ? "This field is required." : false,
          maxLength: {
            value: maxLength,
            message: "Invalid phone number",
          },
          minLength: {
            value: maxLength,
            message: "Invalid phone number",
          },
        }}
        international={true}
        defaultValue={defaultValue}
        defaultCountry="NG"
        countryCallingCodeEditable={false}
        disabled={isDisabled}
      />
    </div>
  );
};

export default PhoneNumber;
