import React, { useEffect } from 'react';
import { Controller, Control } from 'react-hook-form';
import StarRatings from 'react-star-ratings';

interface StarRatingProps {
    control: Control<any>;
    fieldName: string;
    required?: boolean;
    defaultValue?: number;
}

const StarRating: React.FC<StarRatingProps> = ({
    control,
    fieldName,
    required,
    defaultValue,
}) => {
    return (
        <Controller
            name={fieldName}
            control={control}
            defaultValue={defaultValue}
            rules={{ required: required ? 'This field is required' : false }}
            render={({ field: { onChange, value } }) => (
                <StarRatings
                    name={fieldName}
                    rating={value ? value : defaultValue}
                    starRatedColor="gold"
                    starHoverColor='gold'
                    changeRating={onChange}
                    numberOfStars={5}
                    starDimension="25px"
                    starSpacing="2px"
                />
            )}
        />
    );
};

export default StarRating;