import { Editor } from "@tiptap/react";
import React from "react";
import { Controller } from "react-hook-form";
import Tiptap from "~/components/ui/Tiptap";

interface TextEditorProps {
  fieldName: string;
  control: any;
  required?: boolean;
  isDisabled?: boolean;
  validateFn?: any;
  onChangeFn?: (value: Editor) => void;
  defaultValue?: string;
}

const TextEditor: React.FC<TextEditorProps> = ({
  fieldName,
  control,
  required,
  isDisabled = false,
  validateFn,
  onChangeFn,
  defaultValue,
}) => {

  return (
    <Controller
      name={fieldName}
      control={control}
      rules={{
        required: required ? "This field is required." : false,
        minLength: 5,
        validate: validateFn,
      }}
      render={({ field }) => (
        <Tiptap
          defaultContent={defaultValue}
          onChange={(editor: any) => {
            field.onChange(editor.getHTML()); // Directly set the HTML value
            console.log(editor);

            if (onChangeFn) {
              onChangeFn(editor);
            }
          }}
        />
      )}
    />
  );
};

export default TextEditor;