import { Check } from "lucide-react";

interface PasswordCriteriaProps {
  criteria: {
    [key: string]: boolean; // Key is the criteria name, value is whether it's valid
  };
}

const labels: { [key: string]: string } = {
  specialCharacter: "1 special character",
  containsNumber: "1 number",
  containsUppercase: "1 upper case",
  containsLowercase: "1 lower case",
  eightCharacter: "At least 8 characters",
};

const PasswordCriteria = ({ criteria }: PasswordCriteriaProps) => {
  return (
    <div className="flex flex-wrap gap-2">
      {Object.entries(criteria).map(([key, isValid]) => (
        <div
          key={key}
          className={`${
            isValid
              ? "bg-green-50 text-green-800"
              : "bg-slate-50 text-slate-800"
          } flex gap-2 items-center w-fit rounded-full px-2.5 pr-3 py-1`}
        >
          <div
            className={`border-2 ${
              isValid ? "border-green-800" : "border-gray-800"
            } w-5 h-5 rounded-full flex justify-center items-center`}
          >
            <Check size={16} />
          </div>
          {labels[key]}
        </div>
      ))}
    </div>
  );
};

export default PasswordCriteria;
