import { Check } from "lucide-react";
import { images, svgs } from "../assets/index";
import { useAuth } from "~/hooks/store/useAuth";
import { useNavigate } from "@remix-run/react";
import { useEffect } from "react";

interface AuthLayoutProp {
  children: React.ReactNode;
  title: string;
  subtitle: string;
}

const AuthLayout = ({ children, title, subtitle }: AuthLayoutProp) => {
  const navigate = useNavigate();
  const { user } = useAuth();

  useEffect(() => {
    if (user?.access) {
      navigate("/");
    }
  }, [user, navigate]);

  const advantage = [
    "Design, customize, and shop seamlessly",
    "Access your saved designs",
    "Track your orders",
  ];

  return (
    <div className="flex h-screen">
      <div className="flex flex-col justify-between items-start bg-[url('/app/assets/auth/grid-background.svg')] bg-contain w-full h-full bg-[#101212] py-12 px-3">
        <div className="flex flex-col gap-5 max-w-xl mx-auto">
          <p className="text-white text-5xl leading-snug font-semibold">
            {title}
          </p>
          <p className="text-white text-xl">{subtitle}</p>
        </div>
        <div className="flex flex-col gap-5 max-w-xl mx-auto text-white w-full">
          <img
            src={images.authImg}
            alt="Profile Images"
            className="h-12 w-fit"
          />
          <p className="text-lg">
            Join 10,000+ People Creating and Personalizing Their Products
          </p>

          {advantage.map((item, index) => (
            <div key={index} className="flex gap-2 items-center text-lg">
              <div className="text-primary border-2 border-primary w-7 h-7 rounded-full pt-1 px-0.5">
                <Check size={18} />
              </div>
              {item}
            </div>
          ))}
        </div>
      </div>
      <div className="w-full h-full overflow-y-auto py-5">
        <div className="flex flex-col gap-y-24 max-w-xl h-full mx-auto px-3">
          <div>
            <img src={svgs.logo} alt="Profile Images" className="h-10 w-fit" />
          </div>
          <div className="h-full">{children}</div>
        </div>
      </div>
    </div>
  );
};

export default AuthLayout;
