import { Button } from "~/components/ui/button";
import AuthLayout from "../layout/Auth";
import { useForm, SubmitHandler, FormProvider } from "react-hook-form";
import Heading from "~/components/core/Text/Heading";
import FormElement from "~/components/core/FormElements/FormElement";
import { Link } from "@remix-run/react";
import { LoginProps } from "~/store/features/auth/type";

const AuthHeading = {
  title: "Manage OnePrint with ease",
  subtitle:
    "Log in to access the admin dashboard, track user activity, and oversee operations",
};

const MainHeading = {
  title: "Login",
  subtitle: "Hey there! Welcome back 👋",
};

const Login = () => {
  const methods = useForm<LoginProps>();

  const { handleSubmit } = methods;

  const onSubmit: SubmitHandler<LoginProps> = (data) => console.log(data);

  return (
    <AuthLayout title={AuthHeading.title} subtitle={AuthHeading.subtitle}>
      <FormProvider {...methods}>
        <form
          className="flex flex-col gap-5 w-full"
          onSubmit={handleSubmit(onSubmit)}
        >
          <Heading title={MainHeading.title} subtitle={MainHeading.subtitle} />
          <FormElement
            type="email"
            fieldName="email"
            fieldLabel="Work Email"
            required
          />
          <FormElement type="password" fieldName="password" required />
          <Link
            to="/forgot-password"
            className="font-semibold self-end hover:text-primary"
          >
            Forgot your password?
          </Link>
          <Button size="lg" text="Log in" />
          <p className="flex gap-2 justify-center font-semibold">
            Don&apos;t have an account?{" "}
            <Link to="/admin/signup" className="text-primary">
              Create account
            </Link>
          </p>
        </form>
      </FormProvider>
    </AuthLayout>
  );
};

export default Login;
