import { apiSlice } from "../../api/auth";
import { ResetPasswordProps, SignupProps, SignUpResponse } from "./type";

const contactusApi = apiSlice.injectEndpoints({
  endpoints: (builder) => ({
    SignUp: builder.mutation<SignUpResponse, SignupProps>({
      query: (SubmittedData) => ({
        url: `/auth/register/`,
        method: "POST",
        body: SubmittedData,
      }),
    }),
    verifyOtp: builder.mutation<SignUpResponse, SignupProps>({
      query: (SubmittedData) => ({
        url: `/auth/registration/verify-email/`,
        method: "POST",
        body: SubmittedData,
      }),
    }),
    resendOtp: builder.mutation<SignUpResponse, { email: string }>({
      query: (SubmittedData) => ({
        url: `/auth/registration/resend-email/`,
        method: "POST",
        body: SubmittedData,
      }),
    }),
    forgotPassword: builder.mutation<SignUpResponse, { email: string }>({
      query: (SubmittedData) => ({
        url: `/auth/password/reset/`,
        method: "POST",
        body: SubmittedData,
      }),
    }),
    resetPassword: builder.mutation<SignUpResponse, ResetPasswordProps>({
      query: (SubmittedData) => ({
        url: `/auth/password/reset/confirm/`,
        method: "POST",
        body: SubmittedData,
      }),
    }),
  }),
});

export const {
  useSignUpMutation,
  useResendOtpMutation,
  useForgotPasswordMutation,
  useResetPasswordMutation,
} = contactusApi;

export default contactusApi;
