import { configureStore } from '@reduxjs/toolkit'
import { apiSlice } from './api/auth'
import authReducer from '../store/features/auth/authSlice'
import { noAuth } from './api/noAuth'

export const store = configureStore({
  reducer: {
    [apiSlice.reducerPath]: apiSlice.reducer,
    [noAuth.reducerPath]: noAuth.reducer,
    auth: authReducer,
  },
  middleware: (getDefaultMiddleware) =>
    getDefaultMiddleware().concat(apiSlice.middleware, noAuth.middleware),
})

export type RootState = ReturnType<typeof store.getState>
export type AppDispatch = typeof store.dispatch